using System;
using Server;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a spider corpse" )]
	public class EvoSpiderSum : BaseSummonedEvoSpider
	{
      [Constructable]
		public EvoSpiderSum( Xanthos.Evo.EvoSpider master ) : base( master )
		{
			Body = 28;
			BaseSoundID = 0x388;
// 			Hue = 768;

			SetStr( 100 );
			SetDex( 60 );
			SetInt( 10 );

			SetHits( 150 );
			SetStam( 100 );
			SetMana( 0 );

			SetDamage( 8, 10 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Poison, 60 );

			SetResistance( ResistanceType.Physical, 30, 40 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 30, 40 );
			SetResistance( ResistanceType.Poison, 70 );
			SetResistance( ResistanceType.Energy, 20, 30 );

			SetSkill( SkillName.MagicResist, 70.0 );
			SetSkill( SkillName.Tactics, 90.0 );
			SetSkill( SkillName.Wrestling, 90.0 );
			SetSkill( SkillName.Poisoning, 70.0 );
			
			Fame = 0;
			Karma = 0;

			VirtualArmor = 40;
		}
		
		public override Poison PoisonImmune{ get{ return Poison.Regular; } }
		public override Poison HitPoison{ get{ return Poison.Regular; } }

		public EvoSpiderSum( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}